//Study of Multipath Fading Channel
// OS-Windows 10
// Scilab 6.1.0
// Course Instructor Name: Dr. V. A. Sankar Ponnapalli
// Institute Name: ICFAI Foundation for Higher Education Hyderabad

clc;
clear;
close;

printf("Enter number of frequency points N (power of 2, between 128 and 4096):\n");
N = input("N = ");
if ~((floor(log2(N)) == log2(N)) & N >= 128 & N <= 4096) then
    error("Error: N must be a power of 2 between 128 and 4096.");
end

// Input for max Doppler frequency fm
printf("Enter maximum Doppler frequency shift fm in Hz (e.g., between 10 and 500 Hz):\n");
fm = input("fm = ");
if fm <= 0 | fm > 1000 then
    error("Error: fm must be between 10 and 1000 Hz.");
end

// Input for sampling frequency fs
printf("Enter sampling frequency fs in Hz (must be > 2*fm):\n");
fs = input("fs = ");
if fs <= 2*fm then
    error("Error: fs must be greater than 2 * fm.");
end

// Derived values
df = fs / N;           // Frequency resolution
T = 1 / df;            // Duration of fading waveform
f = (-N/2:N/2-1)*df;   // Frequency axis

// --- GENERATE DOPPLER SPECTRUM S_Eg(f) ---
Se = zeros(1, N);
for i = 1:N
    f_norm = f(i) / fm;
    if abs(f_norm) < 1 then
        Se(i) = 1.5 / (%pi * fm * sqrt(1 - f_norm^2));
    else
        Se(i) = 0;
    end
end

// --- GENERATE COMPLEX GAUSSIAN NOISE ---
rand("normal");
gauss_real = rand(1, N, "normal");
gauss_imag = rand(1, N, "normal");
Gf = (gauss_real + %i * gauss_imag) / sqrt(2);

// --- SHAPE NOISE WITH DOPPLER SPECTRUM ---
Sqrt_Se = sqrt(Se);
Hf = Gf .* Sqrt_Se;

// --- IFFT TO TIME DOMAIN ---
Hf_shifted = fftshift(Hf);
ht = ifft(Hf_shifted);       
ht = ht * sqrt(N);           // Normalize

// --- COMPUTE RAYLEIGH ENVELOPE ---
rayleigh_envelope = sqrt(real(ht).^2 + imag(ht).^2);

t = (0:N-1)/fs;
scf(1);
plot(t, rayleigh_envelope);
xlabel("Time (s)");
ylabel("Rayleigh Envelope Amplitude");
title("Rayleigh Fading Envelope (Clarke & Gans Model)");

// Description of the Figure
// User Inputs:
//Enter number of frequency points N (power of 2, between 128 and 4096):
//N = 1024
//Enter maximum Doppler frequency shift fm in Hz (e.g., between 10 and 500 Hz):
//fm = 100
//Enter sampling frequency fs in Hz (must be > 2*fm):
//fs = 1000
// The figure titled "Rayleigh Fading Envelope (Clarke & Gans Model)" exhibits rapid variations typical of Rayleigh fading with many fades per second, consistent with a Doppler frequency  //of 100 Hz.
